<?php

	// Dsactive Zlib.output_compression si activ
	ini_set('zlib.output_compression','Off');
	
	// ACTIVATION / DESACTIVATION DU CACHE ET DE LA COMPRESSION (true/false)
	$cache = true;
	$minifier = true;
	
	$cachedir = dirname(__FILE__) . '/cache';
	$cssdir   = dirname(__FILE__) . '/css';
	$jsdir    = dirname(__FILE__) . '/js';	

	// Dtermine le type de fichier
	switch ($_GET['type']){
		case 'css':
			$base = realpath($cssdir);			
			break;
		case 'javascript':
			$base = realpath($jsdir);
			break;
		default:
			header ("HTTP/1.0 503 Not Implemented");
			exit;
	};

	$type = $_GET['type'];
	$elements = explode(',', $_GET['files']);
	
	//foreach($elements as $key => $element) if(strstr($element,"style") AND 'css' == $type) $elements[$key] = 'style.css';
	
	// Dtermine la date de dernire modification des fichiers
	$lastmodified = 0;
	while (list(,$element) = each($elements)){	
		$path = realpath($base.'/'.$element);		
		if (($type == 'javascript' && substr($path, -3) != '.js') || 
			($type == 'css' && substr($path, -4) != '.css')) {					
			header ("HTTP/1.1 403 Forbidden");
			exit;	
		}	
		if (!file_exists($path)) {		
			header ("HTTP/1.1 404 Not Found");
			exit;
		}		
		$lastmodified = max($lastmodified, filemtime($path));
	}
	
	// Gnre les Etags
	$hash = $lastmodified . '-' . md5($_GET['files']);
	header ("Etag: \"" . $hash . "\"");

	if (isset($_SERVER['HTTP_IF_NONE_MATCH']) && 
		stripslashes($_SERVER['HTTP_IF_NONE_MATCH']) == '"' . $hash . '"' && 1 == 2) 
	{	
		// Si aucune modif depuis la dernire visite ne rien envoyer
		header("expires: Thu, 15 Apr 2015 20:00:00 GMT");
		header("Cache-Control: max-age=2592000");
		header("Last-Modified: Sat, 26 Feb 2010 12:45:26 GMT");
	} 
	else 
	{
		// Premire visite ou bien fichiers modifis
		if ($cache) 
		{
			// Dtermine la mthode de compression supporte
			$gzip = strstr($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip');
			$deflate = strstr($_SERVER['HTTP_ACCEPT_ENCODING'], 'deflate');
	
			// Dtermine la compression  utiliser
			$encoding = $gzip ? 'gzip' : ($deflate ? 'deflate' : 'none');
	
			// En cas de navigateur insalubre - IE6
			if (!strstr($_SERVER['HTTP_USER_AGENT'], 'Opera') && 
				preg_match('/^Mozilla\/4\.0 \(compatible; MSIE ([0-9]\.[0-9])/i', $_SERVER['HTTP_USER_AGENT'], $matches)) {
				$version = floatval($matches[1]);				
				if($version < 6) $encoding = 'none';
				if ($version == 6 && !strstr($_SERVER['HTTP_USER_AGENT'], 'EV1')) $encoding = 'none';
			}
			
			// Regarde dans le cache si les fichiers ont dj t gnrs
			$cachefile = 'cache-' . $hash . '.' . $type . ($encoding != 'none' ? '.' . $encoding : '');
			
			if (file_exists($cachedir . '/' . $cachefile)) {
				if ($fp = fopen($cachedir . '/' . $cachefile, 'rb')){
					if ($encoding != 'none') header ("Content-Encoding: " . $encoding);				
					header ("Content-Type: text/" . $type);
					header ("Vary: Accept-Encoding");
					header ("Content-Length: " . filesize($cachedir . '/' . $cachefile));
					header ('Cache-Control: max-age=2592000');
					fpassthru($fp);
					fclose($fp);
					exit;
				}
			}
		}
	
		// Rcupre le contenu des fichiers
		$contents = '';
		reset($elements);
		while (list(,$element) = each($elements)) {
			$path = realpath($base.'/'.$element);
			$contents .= "\n\n" . file_get_contents($path);
		}		
		
		// Minifie - suppression des espaces et autres caractres superflus
		if ($minifier && $type == 'css') $contents = minifycss($contents); 
		elseif ($minifier && $type == 'javascript') $contents = minifyjs($contents);		
	
		// Un header Content-Type pour la route
		header ("Content-Type: text/" . $type);
		
		if (isset($encoding) && $encoding != 'none') 
		{
			// Compresse le tout
			$contents = gzencode($contents, 9, $gzip ? FORCE_GZIP : FORCE_DEFLATE);
			header ("Content-Encoding: " . $encoding);
		} 

		// Et voil ma bonne dame !
		header ("Vary: Accept-Encoding");
		header ('Content-Length: ' . strlen($contents));
		header ('Cache-Control: max-age=2592000');
		echo $contents;

		// Stocke le cache
		if ($cache) {
			if ($fp = fopen($cachedir . '/' . $cachefile, 'wb')) {
				fwrite($fp, $contents);
				fclose($fp);
			}
			// Supprime les anciennes versions du cache
			$dh = opendir($cachedir);
			while (false !== ($filename = readdir($dh))) {
				if ($filename == '.' || $filename == '..')
				continue;
				if (strpos($filename, '-' . md5($_GET['files']) . '.' . $type . ($encoding != 'none' ? '.' . $encoding : '')) && $filename != $cachefile)
				unlink($cachedir . '/' . $filename);
			}
		}
	}
	
	
function minifycss( $css ) {

	$css = preg_replace( '#\s+#', ' ', $css );
	$css = preg_replace( '#/\*.*?\*/#s', '', $css );
	$css = str_replace( '; ', ';', $css );
	$css = str_replace( ': ', ':', $css );
	$css = str_replace( ' {', '{', $css );
	$css = str_replace( '{ ', '{', $css );
	$css = str_replace( ', ', ',', $css );
	$css = str_replace( '} ', '}', $css );
	$css = str_replace( ';}', '}', $css );

	return trim( $css );
}

function minifyjs( $js ) {
	include 'jsmin.php';	
	$js = JSMin::minify($js);
	return $js;	
}

?>